/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.client.Session;
import dev.upcraft.datasync.web.HttpUtil;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class SessionStore {
    private static final Codec<Pair<String, Long>> CHALLENGE_TOKEN_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("token").forGetter(Pair::getFirst), (App)Codec.LONG.fieldOf("expires_in").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private static final Codec<Session> SESSION_TOKEN_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_41525.fieldOf("user_id").forGetter(Session::userId), (App)Codec.STRING.fieldOf("session_token").forGetter(Session::accessToken), (App)class_5699.field_39042.fieldOf("expires_at").forGetter(Session::expiresAt)).apply((Applicative)instance, Session::new));
    @Nullable
    private Instant cooldownUntil;
    @Nullable
    private Session session;

    @Nullable
    public UUID getUserId() {
        if (this.session == null) {
            return null;
        }
        return this.session.userId();
    }

    @Nullable
    public Session getSession() {
        return this.session;
    }

    public Either<Session, String> login() {
        if (this.cooldownUntil != null && this.cooldownUntil.isAfter(Instant.now())) {
            return Either.right((Object)"Rate limited");
        }
        class_320 mcSession = class_310.method_1551().method_1548();
        GameProfile profile = mcSession.method_1677();
        String profileId = profile.getId().toString();
        JsonObject challengeReqData = new JsonObject();
        challengeReqData.addProperty("id", profileId);
        URI challengeUri = URI.create("%s/auth/mojang/challenge".formatted("https://datasync-api.uuid.gg/api"));
        JsonElement response = HttpUtil.postJson(challengeUri, (JsonElement)challengeReqData);
        Optional<Pair> opt = CHALLENGE_TOKEN_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)response).resultOrPartial(err -> DataSyncMod.LOGGER.error("received malformed response for login challenge: {}", err)).map(Pair::getFirst);
        if (opt.isEmpty()) {
            this.cooldownUntil = Instant.now().plus(30L, ChronoUnit.SECONDS);
            return Either.right((Object)"Received malformed login challenge");
        }
        String challenge = (String)opt.get().getFirst();
        try {
            class_310.method_1551().method_1495().joinServer(profile, mcSession.method_1674(), challenge);
        }
        catch (AuthenticationException e) {
            DataSyncMod.LOGGER.error("Unable to authenticate", (Throwable)e);
            this.cooldownUntil = Instant.now().plus(30L, ChronoUnit.SECONDS);
            return Either.right((Object)"Unable to authenticate with Mojang session servers");
        }
        JsonObject authSuccessData = new JsonObject();
        authSuccessData.addProperty("id", profileId);
        authSuccessData.addProperty("username", mcSession.method_1677().getName());
        authSuccessData.addProperty("token", challenge);
        URI authSuccessUri = URI.create("%s/auth/mojang".formatted("https://datasync-api.uuid.gg/api"));
        response = HttpUtil.postJson(authSuccessUri, (JsonElement)authSuccessData);
        Optional<Session> dsSessionOpt = SESSION_TOKEN_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)response).resultOrPartial(err -> DataSyncMod.LOGGER.error("received malformed response for login success: {}", err)).map(Pair::getFirst);
        if (dsSessionOpt.isEmpty()) {
            return Either.right((Object)"Received malformed session response");
        }
        this.session = dsSessionOpt.get();
        DataSyncMod.LOGGER.debug("Successfully authenticated, session valid until {}", (Object)dsSessionOpt.get().expiresAt());
        return Either.left((Object)dsSessionOpt.get());
    }
}

